/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.display.score;

import java.util.function.IntUnaryOperator;
import net.impactdev.impactor.api.scoreboards.score.Score;
import net.impactdev.impactor.api.scoreboards.score.ScoreFormatter;
import org.jetbrains.annotations.Nullable;

public final class ImpactorScore
implements Score {
    private final ScoreFormatter formatter;
    private final int value;
    private final boolean locked;

    public ImpactorScore(ImpactorScoreBuilder builder) {
        this.value = builder.value;
        this.locked = builder.locked;
        this.formatter = builder.formatter;
    }

    @Override
    public boolean locked() {
        return this.locked;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    @Nullable
    public ScoreFormatter formatter() {
        return this.formatter;
    }

    public Score.Mutable asMutable() {
        return new ImpactorMutableScore(this.value, this.formatter, this.locked);
    }

    public static final class ImpactorScoreBuilder
    implements Score.ScoreBuilder {
        private int value;
        private boolean locked;
        private ScoreFormatter formatter;

        @Override
        public Score.ScoreBuilder score(int score) {
            this.value = score;
            return this;
        }

        @Override
        public Score.ScoreBuilder formatter(ScoreFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        @Override
        public Score.ScoreBuilder locked(boolean state) {
            this.locked = state;
            return this;
        }

        @Override
        public Score build() {
            return new ImpactorScore(this);
        }
    }

    public static final class ImpactorMutableScore
    implements Score.Mutable {
        private final ScoreFormatter formatter;
        private int score;
        private boolean locked;

        public ImpactorMutableScore(int score, ScoreFormatter formatter, boolean locked) {
            this.score = score;
            this.formatter = formatter;
            this.locked = locked;
        }

        @Override
        public boolean locked() {
            return this.locked;
        }

        @Override
        public void lock() {
            this.locked = true;
        }

        @Override
        public void unlock() {
            this.locked = false;
        }

        @Override
        public int value() {
            return this.score;
        }

        @Override
        @Nullable
        public ScoreFormatter formatter() {
            return this.formatter;
        }

        @Override
        public boolean update(IntUnaryOperator operator) {
            if (this.locked) {
                return false;
            }
            this.score = operator.applyAsInt(this.score);
            return true;
        }

        @Override
        public boolean set(int value) {
            if (this.locked) {
                return false;
            }
            this.score = value;
            return true;
        }
    }
}

